/*
 * Decompiled with CFR 0.152.
 */
package com.hospital.api;

import com.hospital.api.AppointmentsController;
import com.hospital.model.AppointmentDoc;
import com.hospital.repository.AppointmentRepository;
import com.hospital.repository.DoctorRepository;
import com.hospital.repository.PatientRepository;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/appointments"})
@CrossOrigin(origins={"http://localhost:3000"})
public class AppointmentsController {
    private final AppointmentRepository apptRepo;
    private final DoctorRepository doctorRepo;
    private final PatientRepository patientRepo;

    public AppointmentsController(AppointmentRepository apptRepo, DoctorRepository doctorRepo, PatientRepository patientRepo) {
        this.apptRepo = apptRepo;
        this.doctorRepo = doctorRepo;
        this.patientRepo = patientRepo;
    }

    @GetMapping
    public List<AppointmentDoc> all() {
        return this.apptRepo.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<AppointmentDoc> byId(@PathVariable String id) {
        return this.apptRepo.findById((Object)id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/byDoctor/{doctorId}"})
    public List<AppointmentDoc> byDoctor(@PathVariable String doctorId) {
        return this.apptRepo.findByDoctorId(doctorId);
    }

    @GetMapping(value={"/byPatient/{patientId}"})
    public List<AppointmentDoc> byPatient(@PathVariable String patientId) {
        return this.apptRepo.findByPatientId(patientId);
    }

    @PostMapping
    public ResponseEntity<?> create(@RequestBody CreateOrUpdate req) {
        try {
            AppointmentsController.require((boolean)this.doctorRepo.existsById((Object)req.doctorId), (String)("Doctor not found: " + req.doctorId));
            AppointmentsController.require((boolean)this.patientRepo.existsById((Object)req.patientId), (String)("Patient not found: " + req.patientId));
            LocalDateTime start = AppointmentsController.parseStart((CreateOrUpdate)req);
            LocalDateTime end = req.end != null ? req.end : start.plusHours(1L);
            AppointmentDoc a = new AppointmentDoc();
            a.setId(UUID.randomUUID().toString());
            a.setDoctorId(req.doctorId);
            a.setPatientId(req.patientId);
            a.setStart(start.toString());
            a.setEnd(end.toString());
            a.setStartTime(Long.valueOf(AppointmentsController.toEpochMillis((LocalDateTime)start)));
            a.setEndTime(Long.valueOf(AppointmentsController.toEpochMillis((LocalDateTime)end)));
            a.setStatus(req.status == null ? AppointmentDoc.Status.SCHEDULED : AppointmentDoc.Status.valueOf((String)req.status));
            return ResponseEntity.ok((Object)((AppointmentDoc)this.apptRepo.save((Object)a)));
        }
        catch (IllegalArgumentException ex) {
            return ResponseEntity.badRequest().body((Object)AppointmentsController.msg((String)ex.getMessage()));
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<?> update(@PathVariable String id, @RequestBody CreateOrUpdate req) {
        return this.apptRepo.findById((Object)id).map(a -> {
            if (req.doctorId != null) {
                a.setDoctorId(req.doctorId);
            }
            if (req.patientId != null) {
                a.setPatientId(req.patientId);
            }
            if (req.status != null) {
                a.setStatus(AppointmentDoc.Status.valueOf((String)req.status));
            }
            if (req.start != null || req.date != null || req.end != null) {
                LocalDateTime start = req.start != null ? req.start : AppointmentsController.parseStart((CreateOrUpdate)req);
                LocalDateTime end = req.end != null ? req.end : start.plusHours(1L);
                a.setStart(start.toString());
                a.setEnd(end.toString());
                a.setStartTime(Long.valueOf(AppointmentsController.toEpochMillis((LocalDateTime)start)));
                a.setEndTime(Long.valueOf(AppointmentsController.toEpochMillis((LocalDateTime)end)));
            }
            return ResponseEntity.ok((Object)((AppointmentDoc)this.apptRepo.save(a)));
        }).orElse(ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable String id) {
        if (!this.apptRepo.existsById((Object)id)) {
            return ResponseEntity.notFound().build();
        }
        this.apptRepo.deleteById((Object)id);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{id}/complete"})
    public ResponseEntity<?> complete(@PathVariable String id) {
        return this.apptRepo.findById((Object)id).map(a -> {
            a.setStatus(AppointmentDoc.Status.COMPLETED);
            this.apptRepo.save(a);
            this.doctorRepo.findById((Object)a.getDoctorId()).ifPresent(d -> {
                Integer visits = d.getNumVisitedPatients() == null ? 0 : d.getNumVisitedPatients();
                d.setNumVisitedPatients(Integer.valueOf(visits + 1));
                this.doctorRepo.save(d);
            });
            this.patientRepo.findById((Object)a.getPatientId()).ifPresent(p -> {
                p.setLastVisitedAt(a.getStart());
                p.setLastVisitedDoctor(a.getDoctorId());
                this.patientRepo.save(p);
            });
            return ResponseEntity.ok((Object)a);
        }).orElse(ResponseEntity.notFound().build());
    }

    private static void require(boolean ok, String msg) {
        if (!ok) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static LocalDateTime parseStart(CreateOrUpdate req) {
        if (req.start != null) {
            return req.start;
        }
        if (req.date != null) {
            try {
                return LocalDateTime.parse(req.date);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Invalid date. Use 2025-10-01T10:00");
            }
        }
        throw new IllegalArgumentException("Missing start/date");
    }

    private static long toEpochMillis(LocalDateTime ldt) {
        return ldt.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    private static Map<String, Object> msg(String m) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("message", m);
        return map;
    }
}

