/*
 * Decompiled with CFR 0.152.
 */
package com.hospital.api;

import com.hospital.model.Doctor;
import com.hospital.repository.DoctorRepository;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/doctors"})
@CrossOrigin(origins={"http://localhost:3000"})
public class DoctorsController {
    private final DoctorRepository repo;

    public DoctorsController(DoctorRepository repo) {
        this.repo = repo;
    }

    @GetMapping
    public List<Doctor> all() {
        return this.repo.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Doctor> one(@PathVariable String id) {
        return this.repo.findById((Object)id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping
    public Doctor create(@RequestBody Doctor d) {
        if (d.getNumVisitedPatients() == null) {
            d.setNumVisitedPatients(Integer.valueOf(0));
        }
        if (d.getMonthlyWorkingHours() == null) {
            d.setMonthlyWorkingHours(Integer.valueOf(0));
        }
        if (d.getPaycheck() == null) {
            d.setPaycheck(Double.valueOf(0.0));
        }
        if (d.getOfficeVisitFee() == null) {
            d.setOfficeVisitFee(Double.valueOf(0.0));
        }
        return (Doctor)this.repo.save((Object)d);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Doctor> update(@PathVariable String id, @RequestBody Doctor d) {
        return this.repo.findById((Object)id).map(x -> {
            if (d.getFirstName() != null) {
                x.setFirstName(d.getFirstName());
            }
            if (d.getLastName() != null) {
                x.setLastName(d.getLastName());
            }
            if (d.getAddress() != null) {
                x.setAddress(d.getAddress());
            }
            if (d.getSpecialty() != null) {
                x.setSpecialty(d.getSpecialty());
            }
            if (d.getOfficeVisitFee() != null) {
                x.setOfficeVisitFee(d.getOfficeVisitFee());
            }
            if (d.getNumVisitedPatients() != null) {
                x.setNumVisitedPatients(d.getNumVisitedPatients());
            }
            if (d.getMonthlyWorkingHours() != null) {
                x.setMonthlyWorkingHours(d.getMonthlyWorkingHours());
            }
            if (d.getPaycheck() != null) {
                x.setPaycheck(d.getPaycheck());
            }
            return ResponseEntity.ok((Object)((Doctor)this.repo.save(x)));
        }).orElse(ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable String id) {
        if (!this.repo.existsById((Object)id)) {
            return ResponseEntity.notFound().build();
        }
        this.repo.deleteById((Object)id);
        return ResponseEntity.noContent().build();
    }
}

