/*
 * Decompiled with CFR 0.152.
 */
package com.hospital.api;

import com.hospital.model.Patient;
import com.hospital.repository.PatientRepository;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/patients"})
@CrossOrigin(origins={"http://localhost:3000"})
public class PatientsController {
    private final PatientRepository repo;

    public PatientsController(PatientRepository repo) {
        this.repo = repo;
    }

    @GetMapping
    public ResponseEntity<List<Patient>> all() {
        try {
            List patients = this.repo.findAll();
            return ResponseEntity.ok((Object)patients);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Patient> one(@PathVariable String id) {
        try {
            return this.repo.findById((Object)id).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PostMapping
    public ResponseEntity<Patient> create(@RequestBody Patient p) {
        try {
            if (p.getFirstName() == null || p.getFirstName().trim().isEmpty()) {
                return ResponseEntity.badRequest().build();
            }
            if (p.getLastName() == null || p.getLastName().trim().isEmpty()) {
                return ResponseEntity.badRequest().build();
            }
            Patient saved = (Patient)this.repo.save((Object)p);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)saved);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Patient> update(@PathVariable String id, @RequestBody Patient p) {
        try {
            return this.repo.findById((Object)id).map(x -> {
                if (p.getFirstName() != null && !p.getFirstName().trim().isEmpty()) {
                    x.setFirstName(p.getFirstName());
                }
                if (p.getLastName() != null && !p.getLastName().trim().isEmpty()) {
                    x.setLastName(p.getLastName());
                }
                if (p.getAddress() != null) {
                    x.setAddress(p.getAddress());
                }
                if (p.getPrimaryCarePhysician() != null) {
                    x.setPrimaryCarePhysician(p.getPrimaryCarePhysician());
                }
                if (p.getLastVisitedAt() != null) {
                    x.setLastVisitedAt(p.getLastVisitedAt());
                }
                if (p.getLastVisitedDoctor() != null) {
                    x.setLastVisitedDoctor(p.getLastVisitedDoctor());
                }
                return ResponseEntity.ok((Object)((Patient)this.repo.save(x)));
            }).orElse(ResponseEntity.notFound().build());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable String id) {
        try {
            if (!this.repo.existsById((Object)id)) {
                return ResponseEntity.notFound().build();
            }
            this.repo.deleteById((Object)id);
            return ResponseEntity.noContent().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
        }
    }
}

