/*
 * Decompiled with CFR 0.152.
 */
package com.hospital.api;

import com.hospital.repository.DoctorRepository;
import com.hospital.repository.EmployeeRepository;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/payroll"})
@CrossOrigin(origins={"http://localhost:3000"})
public class PayrollController {
    private final DoctorRepository doctorRepo;
    private final EmployeeRepository employeeRepo;

    public PayrollController(DoctorRepository doctorRepo, EmployeeRepository employeeRepo) {
        this.doctorRepo = doctorRepo;
        this.employeeRepo = employeeRepo;
    }

    @GetMapping(value={"/summary"})
    public Map<String, Object> summary() {
        List doctors = this.doctorRepo.findAll();
        List employees = this.employeeRepo.findAll();
        double doctorPayroll = doctors.stream().mapToDouble(d -> (double)PayrollController.safeInt((Integer)d.getNumVisitedPatients()) * PayrollController.safeDouble((Double)d.getOfficeVisitFee())).sum();
        double employeePayroll = employees.stream().mapToDouble(e -> (double)PayrollController.safeInt((Integer)e.getMonthlyWorkingHours()) * PayrollController.safeDouble((Double)e.getHourlyRate())).sum();
        LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
        out.put("doctorPayroll", doctorPayroll);
        out.put("employeePayroll", employeePayroll);
        out.put("total", doctorPayroll + employeePayroll);
        out.put("doctors", doctors);
        out.put("employees", employees);
        return out;
    }

    private static int safeInt(Integer v) {
        return v == null ? 0 : v;
    }

    private static double safeDouble(Double v) {
        return v == null ? 0.0 : v;
    }
}

