/*
 * Decompiled with CFR 0.152.
 */
package com.hospital.model;

import com.hospital.model.ValidationUtils;
import java.util.Objects;
import java.util.UUID;

public abstract class Person {
    private final String uniqueId;
    private String firstName;
    private String lastName;
    private String address;

    protected Person(String uniqueId, String firstName, String lastName, String address) {
        this.uniqueId = uniqueId == null || uniqueId.isBlank() ? UUID.randomUUID().toString() : ValidationUtils.requireNonBlank((String)uniqueId, (String)"uniqueId");
        this.firstName = ValidationUtils.requireNonBlank((String)firstName, (String)"firstName");
        this.lastName = ValidationUtils.requireNonBlank((String)lastName, (String)"lastName");
        this.address = ValidationUtils.requireNonBlank((String)address, (String)"address");
    }

    protected Person(String firstName, String lastName, String address) {
        this(UUID.randomUUID().toString(), firstName, lastName, address);
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getAddress() {
        return this.address;
    }

    public void setFirstName(String firstName) {
        this.firstName = ValidationUtils.requireNonBlank((String)firstName, (String)"firstName");
    }

    public void setLastName(String lastName) {
        this.lastName = ValidationUtils.requireNonBlank((String)lastName, (String)"lastName");
    }

    public void setAddress(String address) {
        this.address = ValidationUtils.requireNonBlank((String)address, (String)"address");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Person)) {
            return false;
        }
        return this.uniqueId.equals(((Person)o).uniqueId);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{uniqueId='" + this.uniqueId + "', firstName='" + this.firstName + "', lastName='" + this.lastName + "', address='" + this.address + "'}";
    }
}

