/*
 * Decompiled with CFR 0.152.
 */
package com.hospital.model;

import java.time.LocalDateTime;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static String requireNonBlank(String value, String field) {
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException(field + " must not be blank");
        }
        return value.trim();
    }

    public static <T> T requireNonNull(T value, String field) {
        return Objects.requireNonNull(value, field + " must not be null");
    }

    public static double requireNonNegative(double value, String field) {
        if (value < 0.0) {
            throw new IllegalArgumentException(field + " must be >= 0");
        }
        return value;
    }

    public static int requireNonNegative(int value, String field) {
        if (value < 0) {
            throw new IllegalArgumentException(field + " must be >= 0");
        }
        return value;
    }

    public static void requireStartBeforeEnd(LocalDateTime start, LocalDateTime end) {
        ValidationUtils.requireNonNull((Object)start, (String)"start");
        ValidationUtils.requireNonNull((Object)end, (String)"end");
        if (!start.isBefore(end)) {
            throw new IllegalArgumentException("start must be before end");
        }
    }

    public static LocalDateTime requireNotInPast(LocalDateTime time, String field) {
        ValidationUtils.requireNonNull((Object)time, (String)field);
        if (time.isBefore(LocalDateTime.now())) {
            throw new IllegalArgumentException(field + " must not be in the past");
        }
        return time;
    }
}

