/*
 * Decompiled with CFR 0.152.
 */
package com.hospital.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    @Value(value="${jwt.secret}")
    private String secretBase64;
    @Value(value="${jwt.expiration}")
    private Long expirationMs;

    private Key getSigningKey() {
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)this.secretBase64);
        return Keys.hmacShaKeyFor((byte[])keyBytes);
    }

    public String generateToken(String username) {
        HashMap claims = new HashMap();
        return this.createToken(claims, username);
    }

    private String createToken(Map<String, Object> claims, String subject) {
        long now = System.currentTimeMillis();
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(new Date(now)).setExpiration(new Date(now + this.expirationMs)).signWith(this.getSigningKey(), SignatureAlgorithm.HS256).compact();
    }

    public boolean validateToken(String token) {
        try {
            Jwts.parserBuilder().setSigningKey(this.getSigningKey()).build().parseClaimsJws(token);
            return !this.isTokenExpired(token);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String extractUsername(String token) {
        return this.extractClaims(token).getSubject();
    }

    private Claims extractClaims(String token) {
        return (Claims)Jwts.parserBuilder().setSigningKey(this.getSigningKey()).build().parseClaimsJws(token).getBody();
    }

    private boolean isTokenExpired(String token) {
        return this.extractClaims(token).getExpiration().before(new Date());
    }
}

